#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Ice DreamerMod01.fsh   by  vgs    
//https://www.shadertoy.com/view/XlSGDK
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Vinicius Graciano Santos - vgs/2015
// https://www.shadertoy.com/view/XlSGDK

#define STEPS 100
#define EPS 0.02
#define FAR 100.0
#define PI 3.14159265359

// smin by iq
float smin( float a, float b, float k )
{
    float h = clamp(0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix(b, a, h) - k*h*(1.0-h);
}

float map(vec3 p) {
    p = mod(p, 10.0) - 5.0;
    return smin(length(p)-1.25, min(length(p.yz), 
                min(length(p.xz), length(p.xy))), 0.5)-1.0;
}

vec3 grad(vec3 p) {
    vec2 q = vec2(0.0, EPS);
    return vec3(map(p + q.yxx) - map(p - q.yxx),
                map(p + q.xyx) - map(p - q.xyx),
                map(p + q.xxy) - map(p - q.xxy));
}

// Cube and bump mapping by iq
vec3 cubeMap(vec3 p, vec3 n) {
    vec3 a = texture2D(texture0, 0.1*p.yz).rgb;
    vec3 b = texture2D(texture0, 0.1*p.xz).rgb;
    vec3 c = texture2D(texture0, 0.1*p.xy).rgb;
    n = abs(n);
    return (a*n.x + b*n.y + c*n.z)/(n.x+n.y+n.z);   
}

vec3 bumpMap(vec3 p, vec3 n, float c) {
    vec2 q = vec2(0.0, 0.25);
	vec3 grad = -(vec3(cubeMap(p+q.yxx, n).r, cubeMap(p+q.xyx, n).r, cubeMap(p+q.xxy, n).r)-c)/q.y;
    vec3 t = grad - n*dot(grad, n);
    return normalize(n - t);
}

vec3 shade(vec3 ro, vec3 rd, float t) {
    vec3 p = ro + t*rd;
    vec3 n = normalize(grad(p));
    vec3 tex = cubeMap(p, n);
    n = bumpMap(p, n, tex.r);
    
    vec3 col = 3.0*vec3(0.3, 0.5, 0.7)*tex*(pow(1.0-dot(-rd, n), 4.0)*.6 + .4*dot(-rd, n));
    float fog = 1.0 - exp(-0.01*t);
    return mix(col, vec3(1.0), fog);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    
	vec2 uv = (-iResolution.xy + 2.0*fragCoord.xy) / iResolution.y;
    vec2 vi = fragCoord.xy/iResolution.xy;
    
    vec3 ro = vec3(0.0, 0.0, 2.5+iTime);
    vec3 rd = normalize(vec3(uv, -1.0));
    
    float t = 0.0, d = 0.0;
    for (int i = 0; i < STEPS; ++i) {
        d = .55*map(ro + t*rd);
        if (d < EPS || t > FAR) break;
        t += d;
        rd.xy = cos(0.05*d)*rd.xy + sin(0.05*d)*vec2(-rd.y, rd.x);
    }
	
    vec3 col = d < EPS ? shade(ro, rd, t) : vec3(1.0);
	col += 1.0-vec3(1.0)*pow(vi.x*vi.y*(1.0-vi.x)*(1.0-vi.y), 0.03);
    
    col = max(col-0.26, 0.0);
	col = (col*(6.2*col+.5))/(col*(6.2*col+1.7)+0.06);
    
    col = pow(col, vec3(1.0/2.2));    
	fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

